/*
	File:		ConfigFrames.h

	Contains:	Conditional compilation configuration (public)

	Copyright:	 1993-1996 by Apple Computer, Inc., all rights reserved.
	
	Derived from v4 internal, 6/23/96.
*/


#ifndef __CONFIGFRAMES_H
#define __CONFIGFRAMES_H

#ifndef __CONFIGGLOBAL_H
#include "ConfigGlobal.h"
#endif

// ---------------------------------------------------------------------------
// DEFINITIONS
//
// buildsDebugCodeBlocks	Compiler takes function id's for tracking
// canInvokeNativeFunctions	Interpreter uses native version of native functions
// createOldStores			Use 1.x-compatible object store formats
// hasByteswapExternalStrings	Byteswap strings in object streams
// hasCompiler				Include NewtonScript compiler
// hasDebuggerSupportBuiltins	Include debugger support functions
// hasDisasm				Include Disasm() NS function
// hasFakeLargeObjects		Has pseudo-VBO's
// hasFramesFunctionProfiling	Support for NewtonScript function profiling
// hasFramesRainyDayHook	Include low-memory hook
// hasGlobalConstantFunctions	Include NS functions for controlling global constants
// hasGlobalFunctionCheck	Compiler does KnownGlobalFunctions check
// hasLargeObjects			Support for virtual binary objects
// hasNativeCompiler		Include native compiler
// hasNoProtocols			System doesn't support protocols
// hasObjectConsolidation	TObjectHeap supports ConsolidateObjects
// hasOutOfMemoryErrorNumber	OutOfMemory exception uses error number kError_No_Memory
// hasPackageStores			Support for store parts
// hasPackages				Support for packages
// hasProtocolsSupport		Include NewtonScript protocol support functions
// hasPureFunctionSupport	Compiler supports pure functions
// hasROMObjects			REQUIRED [historical]
// hasROMRefVars			"ROM" objects have pseudo-RefVars in "ROM"
// hasRichStrings			Support rich strings
// hasSANE					NCEG functions are available (funny name, eh?)
// hasSoups					Include object store
// hasStringMeasurement		Has NS functions to measure strings
// hasUriah					Include Uriah() function
// hasVMStacks				Uses Newton OS auto-expanding stacks
// useMemStore				Use in-memory TStore
// useNonNewtUIDMask		Set the "non-Newt" bit in soup entry _modtimes
// useTFramesObjectPtr		Rename TObjectPtr to TFramesObjectPtr
// useTBinaryDataPtr		Rename DataPtr to TBinaryDataPtr
// ---------------------------------------------------------------------------


//------------------- target environs

// ARM processor
#define hasROMRefVars	1

#define hasPackages	1
#define hasPackageStores	1
#define canInvokeNativeFunctions 1
#define hasSANE	1
#define hasVMStacks	1


//------------------- systems

#ifdef forNewt
	// PDA device
	#define hasSoups	1
	#ifdef forDebug
		#define hasDebuggerSupportBuiltins	1
	#endif
	#define hasCompiler	1
	#define hasLargeObjects	1
	#define hasOutOfMemoryErrorNumber	1
	#define	hasProtocolsSupport	1
	#define hasFramesFunctionProfiling	1
	#define hasUriah	1
	#define hasRichStrings	1
#endif // forNewt

#ifdef forDocker
	// Mac/PC application for transfering Newton data
	#define hasFakeLargeObjects	1
	#define hasRichStrings	1
	#define hasSoups	1
	#define hasLargeObjects	1
	#define hasFramesRainyDayHook	1
	#define useNonNewtUIDMask	1
	#define useTFramesObjectPtr	1
	#if defined(forDebug) || defined(forDevelopers)	|| defined(_DEBUG)
		#define hasCompiler	1
	#endif
	#define hasROMRefVars	1
#endif // forDocker

#ifdef forFram
	// MPW NewtonScript tool
	#define hasROMRefVars	1
	#define hasSoups	1
	#define useMemStore	1
	#define hasCompiler	1
	#define hasPureFunctionSupport	1
	#define hasGlobalFunctionCheck	1
	#define hasGlobalConstantFunctions	1
	#define hasRichStrings	1
	#define hasDebuggerSupportBuiltins	1
	#define hasStringMeasurement	1
	#define hasNativeCompiler	1
	#define hasUriah	1
	#define hasInterpreter	1
#endif // forFram

#ifdef forNTK
	// Newton Toolkit
	#define hasSoups	1
	#define createOldStores	1
	#define hasFramesRainyDayHook	1
	#define useNonNewtUIDMask	1
	#define useTFramesObjectPtr	1
	#define hasROMRefVars	1
	#define hasCompiler	1
	#define useMemStore	1
	#define hasPureFunctionSupport	1
	#define hasGlobalFunctionCheck	1
	#define hasGlobalConstantFunctions	1
	#define hasDebuggerSupportBuiltins	1
	#define hasStringMeasurement	1
	#define hasNativeCompiler	1
	#define buildsDebugCodeBlocks	1
	#define hasObjectConsolidation 1
#endif // forNTK

#ifdef forStandaloneFrames
	// Frames library
	#define hasROMRefVars	1
	#define hasSoups	1
	#define useMemStore	1
	#define hasCompiler	1
	#define hasPureFunctionSupport	1
	#define hasGlobalFunctionCheck	1
	#define hasDisasm	1
	#define hasUriah	1
	#define hasGlobalConstantFunctions	1
	#define hasDebuggerSupportBuiltins	1
#endif // forStandaloneFrames

#ifdef forFramesAccessLibrary
	#define hasROMRefVars 			1
#endif	// forFramesAccessLibrary

// ---------------------------------------------------------------------------
// Universal switches
// ---------------------------------------------------------------------------

#define hasROMObjects	1		// required (historical)

#if !defined(_MSC_VER)
#define hasFramesCObjects 1
#endif

#ifdef forDocker
#undef hasFramesCObjects
#endif

#ifdef forDebug
	#define hasDisasm	1
#endif


#endif	// __CONFIGFRAMES_H

